<?php
include 'config.php';
session_start();

// التحقق من وجود المستخدم
if (!isset($_SESSION['user_id'])) {
    die("الرجاء تسجيل الدخول أولاً.");
}

$user_id = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // استلام البيانات من النموذج
    $arabic_name = $_POST['arabic_name'];
    $english_name = $_POST['english_name'];
    $personal_email = $_POST['personal_email'];
    $university_email = $_POST['university_email'];
    $birth_date = $_POST['birth_date'];
    $gender = $_POST['gender'];
    $website = $_POST['website'];
    $phone_number = $_POST['phone_number'];
    $degree = $_POST['degree'];
    $major_arabic = $_POST['major_arabic'];
    $major_english = $_POST['major_english'];
    $specialization_arabic = $_POST['specialization_arabic'];
    $specialization_english = $_POST['specialization_english'];
    $academic_title = $_POST['academic_title'];
    $scopus_link = $_POST['scopus_link'];
    $orcid_link = $_POST['orcid_link'];
    $wos_link = $_POST['wos_link'];
    $google_scholar_link = $_POST['google_scholar_link'];
    $researchgate_link = $_POST['researchgate_link'];
    $books_count = $_POST['books_count'];
    $book_chapters_count = $_POST['book_chapters_count'];
    $research_papers_count = $_POST['research_papers_count'];
    $conferences_count = $_POST['conferences_count'];
    $workshops_count = $_POST['workshops_count'];
    $h_index_scopus = $_POST['h_index_scopus'];
    $h_index_clarivate = $_POST['h_index_clarivate'];
    $additional_info_arabic = $_POST['additional_info_arabic'];
    $additional_info_english = $_POST['additional_info_english'];
    $workplace_arabic = $_POST['workplace_arabic'];
    $workplace_english = $_POST['workplace_english'];
    $scientific_memberships_arabic = $_POST['scientific_memberships_arabic'];
    $scientific_memberships_english = $_POST['scientific_memberships_english'];
    $research_area_arabic = $_POST['research_area_arabic'];
    $research_area_english = $_POST['research_area_english'];
    $teaching_experience_arabic = $_POST['teaching_experience_arabic'];
    $teaching_experience_english = $_POST['teaching_experience_english'];

    // توليد الرقم الفريد للسيرة الذاتية (cv_code)
    $cv_code = str_pad(rand(0, 999999), 6, "0", STR_PAD_LEFT);  // توليد 6 أرقام فريدة

    // إضافة السيرة الذاتية للمستخدم
    $sql = "INSERT INTO cv (user_id, cv_code, arabic_name, english_name, personal_email, university_email, birth_date, gender, website, phone_number, degree, major_arabic, major_english, specialization_arabic, specialization_english, academic_title, scopus_link, orcid_link, wos_link, google_scholar_link, researchgate_link, books_count, book_chapters_count, research_papers_count, conferences_count, workshops_count, h_index_scopus, h_index_clarivate, additional_info_arabic, additional_info_english, workplace_arabic, workplace_english, scientific_memberships_arabic, scientific_memberships_english, research_area_arabic, research_area_english, teaching_experience_arabic, teaching_experience_english)
    VALUES (:user_id, :cv_code, :arabic_name, :english_name, :personal_email, :university_email, :birth_date, :gender, :website, :phone_number, :degree, :major_arabic, :major_english, :specialization_arabic, :specialization_english, :academic_title, :scopus_link, :orcid_link, :wos_link, :google_scholar_link, :researchgate_link, :books_count, :book_chapters_count, :research_papers_count, :conferences_count, :workshops_count, :h_index_scopus, :h_index_clarivate, :additional_info_arabic, :additional_info_english, :workplace_arabic, :workplace_english, :scientific_memberships_arabic, :scientific_memberships_english, :research_area_arabic, :research_area_english, :teaching_experience_arabic, :teaching_experience_english)";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'user_id' => $user_id,
        'cv_code' => $cv_code,
        'arabic_name' => $arabic_name,
        'english_name' => $english_name,
        'personal_email' => $personal_email,
        'university_email' => $university_email,
        'birth_date' => $birth_date,
        'gender' => $gender,
        'website' => $website,
        'phone_number' => $phone_number,
        'degree' => $degree,
        'major_arabic' => $major_arabic,
        'major_english' => $major_english,
        'specialization_arabic' => $specialization_arabic,
        'specialization_english' => $specialization_english,
        'academic_title' => $academic_title,
        'scopus_link' => $scopus_link,
        'orcid_link' => $orcid_link,
        'wos_link' => $wos_link,
        'google_scholar_link' => $google_scholar_link,
        'researchgate_link' => $researchgate_link,
        'books_count' => $books_count,
        'book_chapters_count' => $book_chapters_count,
        'research_papers_count' => $research_papers_count,
        'conferences_count' => $conferences_count,
        'workshops_count' => $workshops_count,
        'h_index_scopus' => $h_index_scopus,
        'h_index_clarivate' => $h_index_clarivate,
        'additional_info_arabic' => $additional_info_arabic,
        'additional_info_english' => $additional_info_english,
        'workplace_arabic' => $workplace_arabic,
        'workplace_english' => $workplace_english,
        'scientific_memberships_arabic' => $scientific_memberships_arabic,
        'scientific_memberships_english' => $scientific_memberships_english,
        'research_area_arabic' => $research_area_arabic,
        'research_area_english' => $research_area_english,
        'teaching_experience_arabic' => $teaching_experience_arabic,
        'teaching_experience_english' => $teaching_experience_english
    ]);

    // إضافة البحوث
    if (!empty($_POST['research_title'])) {
        foreach ($_POST['research_title'] as $index => $title) {
            $description = $_POST['research_description'][$index];
            $year = $_POST['research_year'][$index];

            // إدخال البحث في جدول البحوث
            $sql = "INSERT INTO researches (user_id, title, description, year) VALUES (:user_id, :title, :description, :year)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                'user_id' => $user_id,
                'title' => $title,
                'description' => $description,
                'year' => $year
            ]);
        }
    }

    echo "تم إضافة السيرة الذاتية والبحوث بنجاح!";
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>إضافة السيرة الذاتية</title>
</head>
<body>
    <h1>إضافة السيرة الذاتية</h1>
    <form method="post">
        <!-- إضافة الحقول الخاصة بالسيرة الذاتية -->
        <label>الاسم بالعربية:</label><br>
        <input type="text" name="arabic_name" required><br>
        <label>الاسم بالإنجليزية:</label><br>
        <input type="text" name="english_name" required><br>
        <label>البريد الإلكتروني الشخصي:</label><br>
        <input type="email" name="personal_email" required><br>
        <label>البريد الإلكتروني الجامعي:</label><br>
        <input type="email" name="university_email"><br>
        <label>تاريخ الميلاد:</label><br>
        <input type="date" name="birth_date"><br>
        <label>الجنس:</label><br>
        <select name="gender">
            <option value="Male">ذكر</option>
            <option value="Female">أنثى</option>
        </select><br>
        <label>الموقع الإلكتروني:</label><br>
        <input type="text" name="website"><br>
        <label>رقم الموبايل:</label><br>
        <input type="text" name="phone_number"><br>
        <label>الشهادة:</label><br>
        <select name="degree">
            <option value="Undergraduate">دراسات عليا</option>
            <option value="Masters">ماجستير</option>
            <option value="Doctorate">دكتوراه</option>
        </select><br>

        <!-- باقي الحقول مثل الروابط العلمية، الكتب، المؤتمرات -->
        <label>رابط Scopus:</label><br>
        <input type="url" name="scopus_link"><br>
        <label>رابط ORCID:</label><br>
        <input type="url" name="orcid_link"><br>
        <label>رابط WOS:</label><br>
        <input type="url" name="wos_link"><br>
        <label>رابط Google Scholar:</label><br>
        <input type="url" name="google_scholar_link"><br>
        <label>رابط ResearchGate:</label><br>
        <input type="url" name="researchgate_link"><br>

        <!-- الحقول الخاصة بالنتاج العلمي -->
        <label>عدد الكتب:</label><br>
        <input type="number" name="books_count"><br>
        <label>عدد فصول الكتاب:</label><br>
        <input type="number" name="book_chapters_count"><br>
        <label>عدد البحوث والمقالات:</label><br>
        <input type="number" name="research_papers_count"><br>

        <!-- إضافة الحقول الخاصة بالتدريس -->
        <label>عدد المؤتمرات:</label><br>
        <input type="number" name="conferences_count"><br>
        <label>عدد ورش العمل:</label><br>
        <input type="number" name="workshops_count"><br>

        <h3>إضافة أو تحديث البحوث:</h3>
        <div id="research-fields">
            <div class="research">
                <label>عنوان البحث:</label><br>
                <input type="text" name="research_title[]" required><br>
                <label>وصف البحث:</label><br>
                <textarea name="research_description[]" required></textarea><br>
                <label>سنة البحث:</label><br>
                <input type="number" name="research_year[]" required><br>
                <hr>
            </div>
        </div>
        <button type="button" onclick="addResearch()">إضافة بحث جديد</button><br>

        <input type="submit" value="إضافة السيرة الذاتية">
    </form>

    <script>
        function addResearch() {
            var researchDiv = document.createElement('div');
            researchDiv.classList.add('research');
            
            researchDiv.innerHTML = `
                <label>عنوان البحث:</label><br>
                <input type="text" name="research_title[]" required><br>
                <label>وصف البحث:</label><br>
                <textarea name="research_description[]" required></textarea><br>
                <label>سنة البحث:</label><br>
                <input type="number" name="research_year[]" required><br>
                <hr>
            `;
            
            document.getElementById('research-fields').appendChild(researchDiv);
        }
    </script>
</body>
</html>
