<?php
include 'config.php';
session_start();

// التحقق من وجود مشرف
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // التحقق من وجود البريد الإلكتروني في قاعدة البيانات
    $sql = "SELECT * FROM users WHERE email = :email";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['email' => $email]);

    if ($stmt->rowCount() > 0) {
        echo "البريد الإلكتروني مسجل بالفعل!";
    } else {
        // إضافة مشرف جديد
        $sql = "INSERT INTO users (email, password, role) VALUES (:email, :password, 'admin')";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            'email' => $email,
            'password' => password_hash($password, PASSWORD_DEFAULT)
        ]);

        echo "تم إضافة المشرف بنجاح!";
        header("Location: manage_admins.php");
        exit();
    }
}
?>
