<?php
include 'config.php';
session_start();

if (!isset($_SESSION['admin_id'])) {
    die("الرجاء تسجيل الدخول كمسؤول.");
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];
    $role = $_POST['role'];

    // التحقق من وجود البريد الإلكتروني في قاعدة البيانات
    $sql = "SELECT * FROM users WHERE email = :email";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['email' => $email]);

    if ($stmt->rowCount() > 0) {
        echo "البريد الإلكتروني مسجل بالفعل!";
    } else {
        // إضافة مستخدم جديد
        $sql = "INSERT INTO users (email, password, role) VALUES (:email, :password, :role)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            'email' => $email,
            'password' => password_hash($password, PASSWORD_DEFAULT),
            'role' => $role
        ]);

        echo "تم إنشاء المستخدم بنجاح!";
    }
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>إنشاء مستخدم</title>
</head>
<body>
    <h1>إنشاء مستخدم جديد</h1>
    <form method="post">
        <label>البريد الإلكتروني:</label><br>
        <input type="email" name="email" required><br>
        <label>كلمة المرور:</label><br>
        <input type="password" name="password" required><br>
        <label>النوع:</label><br>
        <select name="role">
            <option value="user">مستخدم</option>
            <option value="admin">مشرف</option>
        </select><br>
        <input type="submit" value="إنشاء المستخدم">
    </form>
</body>
</html>
