<?php
include 'config.php';
session_start();

// التحقق من وجود مشرف
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

// استعلام لعرض المستخدمين
$sql = "SELECT * FROM users";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>لوحة تحكم المشرف</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            direction: rtl;
            text-align: right;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: center;
        }
        a {
            text-decoration: none;
            color: blue;
        }
        a:hover {
            text-decoration: underline;
        }
        .admin-links {
            margin: 20px 0;
        }
        .logout {
            margin-top: 20px;
            display: inline-block;
            padding: 10px;
            background-color: #f44336;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
        .logout:hover {
            background-color: #d32f2f;
        }
    </style>
</head>
<body>
    <h1>لوحة تحكم المشرف</h1>
    
    <!-- روابط التنقل الخاصة بالمشرف -->
    <div class="admin-links">
        <a href="create_user.php">إنشاء مستخدم جديد</a> | 
        <a href="promo_codes.php">إدارة الأكواد الترويجية</a> | 
        <a href="manage_admins.php">إدارة المشرفين</a> | 
        <a href="view_reports.php">عرض التقارير</a>
    </div>

    <!-- جدول عرض المستخدمين -->
    <h2>قائمة المستخدمين</h2>
    <table>
        <thead>
            <tr>
                <th>البريد الإلكتروني</th>
                <th>تاريخ التسجيل</th>
                <th>آخر دخول</th>
                <th>الحالة</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                    <td><?php echo $user['registration_date']; ?></td>
                    <td><?php echo $user['last_login']; ?></td>
                    <td>
                        <?php if ($user['is_active']): ?>
                            نشط
                        <?php else: ?>
                            معطل
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="edit_user.php?id=<?php echo $user['id']; ?>">تعديل</a> |
                        <a href="delete_user.php?id=<?php echo $user['id']; ?>">حذف</a> |
                        <a href="toggle_user_status.php?id=<?php echo $user['id']; ?>">تعطيل/تفعيل</a> |
                        <a href="toggle_cv_status.php?id=<?php echo $user['id']; ?>">تعطيل السيرة الذاتية</a> |
                        <a href="block_user.php?id=<?php echo $user['id']; ?>">منع الدخول</a> |
                        <a href="disable_update.php?id=<?php echo $user['id']; ?>">إيقاف التحديث</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- زر الخروج -->
    <a href="logout.php" class="logout">تسجيل الخروج</a>
</body>
</html>
