<?php
include 'config.php';

// استعلام لعرض المستخدمين
$sql = "SELECT * FROM users";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>لوحة تحكم المشرف</title>
</head>
<body>
    <h1>عرض المستخدمين</h1>
    <table border="1">
        <thead>
            <tr>
                <th>البريد الإلكتروني</th>
                <th>تاريخ التسجيل</th>
                <th>آخر دخول</th>
                <th>التحكم</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                    <td><?php echo $user['registration_date']; ?></td>
                    <td><?php echo $user['last_login']; ?></td>
                    <td>
                        <a href="edit_user.php?id=<?php echo $user['id']; ?>">تعديل</a>
                        <a href="delete_user.php?id=<?php echo $user['id']; ?>">حذف</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
