<?php
include 'config.php';

// استعلام لعرض المستخدمين
$sql = "SELECT * FROM users";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>لوحة تحكم المشرف</title>
</head>
<body>
    <h1>لوحة تحكم المشرف</h1>
    <table border="1">
        <thead>
            <tr>
                <th>البريد الإلكتروني</th>
                <th>تاريخ التسجيل</th>
                <th>آخر دخول</th>
                <th>الحالة</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
                <tr>
                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                    <td><?php echo $user['registration_date']; ?></td>
                    <td><?php echo $user['last_login']; ?></td>
                    <td>
                        <?php if ($user['is_active']): ?>
                            نشط
                        <?php else: ?>
                            معطل
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="edit_user.php?id=<?php echo $user['id']; ?>">تعديل</a> |
                        <a href="delete_user.php?id=<?php echo $user['id']; ?>">حذف</a> |
                        <a href="toggle_user_status.php?id=<?php echo $user['id']; ?>">تعطيل/تفعيل</a> |
                        <a href="toggle_cv_status.php?id=<?php echo $user['id']; ?>">تعطيل السيرة الذاتية</a> |
                        <a href="block_user.php?id=<?php echo $user['id']; ?>">منع الدخول</a> |
                        <a href="disable_update.php?id=<?php echo $user['id']; ?>">إيقاف التحديث</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
