<?php
include 'config.php';
session_start();

// التحقق من وجود المشرف
if (!isset($_SESSION['admin_id'])) {
    die("الرجاء تسجيل الدخول كمسؤول.");
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // استلام بيانات المستخدم
    $user_id = $_POST['user_id'];

    // التحقق من وجود المستخدم في قاعدة البيانات
    $sql = "SELECT * FROM users WHERE id = :user_id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['user_id' => $user_id]);

    if ($stmt->rowCount() > 0) {
        // حذف المستخدم من قاعدة البيانات
        $sql = "DELETE FROM users WHERE id = :user_id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(['user_id' => $user_id]);

        echo "تم حذف المستخدم بنجاح!";
    } else {
        echo "المستخدم غير موجود.";
    }
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>حذف مستخدم</title>
</head>
<body>
    <h1>حذف مستخدم</h1>
    <form method="post">
        <label>رقم تعريف المستخدم:</label><br>
        <input type="number" name="user_id" required><br>
        <input type="submit" value="حذف المستخدم">
    </form>
</body>
</html>
