<?php
include 'config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    die("الرجاء تسجيل الدخول أولاً.");
}

// الحصول على بيانات السيرة الذاتية للمستخدم
$user_id = $_SESSION['user_id'];
$sql = "SELECT * FROM cv WHERE user_id = :user_id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['user_id' => $user_id]);
$cv = $stmt->fetch(PDO::FETCH_ASSOC);


// استخراج cv_code من السيرة الذاتية
$cv_code = $cv['cv_code']; // تأكد أن هذا الحقل موجود في قاعدة البيانات

// جلب البحوث الحالية للمستخدم
$sql = "SELECT * FROM researches WHERE user_id = :user_id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['user_id' => $user_id]);
$researches = $stmt->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // استلام البيانات من النموذج
    $arabic_name = $_POST['arabic_name'] ?: $cv['arabic_name'];
    $english_name = $_POST['english_name'] ?: $cv['english_name'];
    $personal_email = $_POST['personal_email'] ?: $cv['personal_email'];
    $university_email = $_POST['university_email'] ?: $cv['university_email'];
    $birth_date = $_POST['birth_date'] ?: $cv['birth_date'];
    $gender = $_POST['gender'] ?: $cv['gender'];
    $website = $_POST['website'] ?: $cv['website'];
    $phone_number = $_POST['phone_number'] ?: $cv['phone_number'];
    $degree = $_POST['degree'] ?: $cv['degree'];
    $major_arabic = $_POST['major_arabic'] ?: $cv['major_arabic'];
    $major_english = $_POST['major_english'] ?: $cv['major_english'];
    $specialization_arabic = $_POST['specialization_arabic'] ?: $cv['specialization_arabic'];
    $specialization_english = $_POST['specialization_english'] ?: $cv['specialization_english'];
    $academic_title = $_POST['academic_title'] ?: $cv['academic_title'];
    $scopus_link = $_POST['scopus_link'] ?: $cv['scopus_link'];
    $orcid_link = $_POST['orcid_link'] ?: $cv['orcid_link'];
    $wos_link = $_POST['wos_link'] ?: $cv['wos_link'];
    $google_scholar_link = $_POST['google_scholar_link'] ?: $cv['google_scholar_link'];
    $researchgate_link = $_POST['researchgate_link'] ?: $cv['researchgate_link'];
    $books_count = $_POST['books_count'] ?: $cv['books_count'];
    $book_chapters_count = $_POST['book_chapters_count'] ?: $cv['book_chapters_count'];
    $research_papers_count = $_POST['research_papers_count'] ?: $cv['research_papers_count'];
    $conferences_count = $_POST['conferences_count'] ?: $cv['conferences_count'];
    $workshops_count = $_POST['workshops_count'] ?: $cv['workshops_count'];
    $h_index_scopus = $_POST['h_index_scopus'] ?: $cv['h_index_scopus'];
    $h_index_clarivate = $_POST['h_index_clarivate'] ?: $cv['h_index_clarivate'];
    $additional_info_arabic = $_POST['additional_info_arabic'] ?: $cv['additional_info_arabic'];
    $additional_info_english = $_POST['additional_info_english'] ?: $cv['additional_info_english'];
    $workplace_arabic = $_POST['workplace_arabic'] ?: $cv['workplace_arabic'];
    $workplace_english = $_POST['workplace_english'] ?: $cv['workplace_english'];
    $scientific_memberships_arabic = $_POST['scientific_memberships_arabic'] ?: $cv['scientific_memberships_arabic'];
    $scientific_memberships_english = $_POST['scientific_memberships_english'] ?: $cv['scientific_memberships_english'];
    $research_area_arabic = $_POST['research_area_arabic'] ?: $cv['research_area_arabic'];
    $research_area_english = $_POST['research_area_english'] ?: $cv['research_area_english'];
    $teaching_experience_arabic = $_POST['teaching_experience_arabic'] ?: $cv['teaching_experience_arabic'];
    $teaching_experience_english = $_POST['teaching_experience_english'] ?: $cv['teaching_experience_english'];

    // تحديث السيرة الذاتية
    $sql = "UPDATE cv SET 
            arabic_name = :arabic_name, 
            english_name = :english_name, 
            personal_email = :personal_email, 
            university_email = :university_email, 
            birth_date = :birth_date, 
            gender = :gender, 
            website = :website, 
            phone_number = :phone_number, 
            degree = :degree, 
            major_arabic = :major_arabic, 
            major_english = :major_english, 
            specialization_arabic = :specialization_arabic, 
            specialization_english = :specialization_english, 
            academic_title = :academic_title, 
            scopus_link = :scopus_link, 
            orcid_link = :orcid_link, 
            wos_link = :wos_link, 
            google_scholar_link = :google_scholar_link, 
            researchgate_link = :researchgate_link, 
            books_count = :books_count, 
            book_chapters_count = :book_chapters_count, 
            research_papers_count = :research_papers_count, 
            conferences_count = :conferences_count, 
            workshops_count = :workshops_count, 
            h_index_scopus = :h_index_scopus, 
            h_index_clarivate = :h_index_clarivate, 
            additional_info_arabic = :additional_info_arabic, 
            additional_info_english = :additional_info_english, 
            workplace_arabic = :workplace_arabic, 
            workplace_english = :workplace_english, 
            scientific_memberships_arabic = :scientific_memberships_arabic, 
            scientific_memberships_english = :scientific_memberships_english, 
            research_area_arabic = :research_area_arabic, 
            research_area_english = :research_area_english, 
            teaching_experience_arabic = :teaching_experience_arabic, 
            teaching_experience_english = :teaching_experience_english 
            WHERE user_id = :user_id";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'arabic_name' => $arabic_name,
        'english_name' => $english_name,
        'personal_email' => $personal_email,
        'university_email' => $university_email,
        'birth_date' => $birth_date,
        'gender' => $gender,
        'website' => $website,
        'phone_number' => $phone_number,
        'degree' => $degree,
        'major_arabic' => $major_arabic,
        'major_english' => $major_english,
        'specialization_arabic' => $specialization_arabic,
        'specialization_english' => $specialization_english,
        'academic_title' => $academic_title,
        'scopus_link' => $scopus_link,
        'orcid_link' => $orcid_link,
        'wos_link' => $wos_link,
        'google_scholar_link' => $google_scholar_link,
        'researchgate_link' => $researchgate_link,
        'books_count' => $books_count,
        'book_chapters_count' => $book_chapters_count,
        'research_papers_count' => $research_papers_count,
        'conferences_count' => $conferences_count,
        'workshops_count' => $workshops_count,
        'h_index_scopus' => $h_index_scopus,
        'h_index_clarivate' => $h_index_clarivate,
        'additional_info_arabic' => $additional_info_arabic,
        'additional_info_english' => $additional_info_english,
        'workplace_arabic' => $workplace_arabic,
        'workplace_english' => $workplace_english,
        'scientific_memberships_arabic' => $scientific_memberships_arabic,
        'scientific_memberships_english' => $scientific_memberships_english,
        'research_area_arabic' => $research_area_arabic,
        'research_area_english' => $research_area_english,
        'teaching_experience_arabic' => $teaching_experience_arabic,
        'teaching_experience_english' => $teaching_experience_english,
        'user_id' => $user_id
    ]);

    // تخزين رسالة النجاح في الجلسة وإعادة التوجيه
    $_SESSION['update_success'] = 'تم تحديث السيرة الذاتية والبحوث بنجاح!';
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>تحديث السيرة الذاتية</title>
    <style>
        /* تصميم بسيط للروابط */
        .nav-links {
            margin-bottom: 20px;
        }
        .nav-links a {
            margin-right: 15px;
            text-decoration: none;
            color: #007BFF;
        }
        .nav-links a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

    <!-- الروابط في الجزء العلوي -->

    <div class="nav-links">
        <a href="logout.php">تسجيل الخروج</a> | 
        <a href="upload_profile_picture.php">تحديث الصورة الشخصية</a> | 
        <a href="update_researches.php">تحديث البحوث</a> | 
        <a href="upgrade.php">ترقية إلى بريميوم</a> | 
    <a href="id.php?cv=<?php echo htmlspecialchars($cv_code); ?>">عرض السيرة</a>
    </div>


<?php
// عرض رسالة النجاح إذا كانت موجودة في الجلسة
if (isset($_SESSION['update_success'])) {
    echo "<p style='color: #006400; font-weight: bold;'>" . $_SESSION['update_success'] . "</p>";
    // حذف الرسالة بعد عرضها
    unset($_SESSION['update_success']);
}
?>
    <h1>الملف الشخصي</h1>

    <?php
    // عرض الصورة الشخصية إذا كانت موجودة
    if (!empty($cv['profile_picture'])) {
        // تحديد المسار الكامل للصورة في المجلد uploads/
        $image_path = 'uploads/' . htmlspecialchars($cv['profile_picture']);
        
        echo "<p><strong>الصورة الشخصية:</strong><br><img src='" . $image_path . "' alt='الصورة الشخصية' style='max-width:200px;'></p>";
    }
    ?>

<!-- عرض الرابط مع زر نسخ -->
    <p>رابط السيرة الذاتية: <span id="cvLinkText">https://iraqid.org/id.php?cv=<?php echo htmlspecialchars($cv_code); ?></span></p>
    <button id="copyBtn" onclick="copyToClipboard()">نسخ الرابط</button>
      
 <script>
// وظيفة نسخ الرابط إلى الحافظة
function copyToClipboard() {
    var text = document.getElementById("cvLinkText").textContent; // الحصول على الرابط من النص
    var textArea = document.createElement("textarea");
    textArea.value = text; // وضع الرابط داخل الـ textarea
    document.body.appendChild(textArea);
    textArea.select(); // تحديد النص داخل الـ textarea
    document.execCommand("copy"); // تنفيذ أمر النسخ
    document.body.removeChild(textArea); // إزالة الـ textarea بعد النسخ

    // يمكنك إضافة إشعار لإعلام المستخدم بأن الرابط تم نسخه بنجاح
    alert("تم نسخ الرابط!");
}
</script>

   <h1>تحديث السيرة الذاتية</h1>
    
    <form method="post">
        <!-- إضافة الحقول الخاصة بالسيرة الذاتية -->
        <label>الاسم بالعربية:</label><br>
        <input type="text" name="arabic_name" value="<?php echo htmlspecialchars($cv['arabic_name']); ?>" required><br>
        <label>الاسم بالإنجليزية:</label><br>
        <input type="text" name="english_name" value="<?php echo htmlspecialchars($cv['english_name']); ?>" required><br>
        <label>البريد الإلكتروني الشخصي:</label><br>
        <input type="email" name="personal_email" value="<?php echo htmlspecialchars($cv['personal_email']); ?>" required><br>
        <label>البريد الإلكتروني الجامعي:</label><br>
        <input type="email" name="university_email" value="<?php echo htmlspecialchars($cv['university_email']); ?>"><br>
        <label>تاريخ الميلاد:</label><br>
        <input type="date" name="birth_date" value="<?php echo $cv['birth_date']; ?>"><br>
        <label>الجنس:</label><br>
        <select name="gender">
            <option value="Male" <?php echo $cv['gender'] == 'Male' ? 'selected' : ''; ?>>ذكر</option>
            <option value="Female" <?php echo $cv['gender'] == 'Female' ? 'selected' : ''; ?>>أنثى</option>
        </select><br>
        <label>الموقع الإلكتروني:</label><br>
        <input type="text" name="website" value="<?php echo htmlspecialchars($cv['website']); ?>"><br>
        <label>رقم الموبايل:</label><br>
        <input type="text" name="phone_number" value="<?php echo htmlspecialchars($cv['phone_number']); ?>"><br>
        <label>الشهادة:</label><br>
        <select name="degree">
            <option value="Undergraduate" <?php echo $cv['degree'] == 'Undergraduate' ? 'selected' : ''; ?>>دراسات عليا</option>
            <option value="Masters" <?php echo $cv['degree'] == 'Masters' ? 'selected' : ''; ?>>ماجستير</option>
            <option value="Doctorate" <?php echo $cv['degree'] == 'Doctorate' ? 'selected' : ''; ?>>دكتوراه</option>
        </select><br>
  <label>التخصص:</label><br>
        <input type="text" name="major_arabic" value="<?php echo htmlspecialchars($cv['major_arabic']); ?>" placeholder="التخصص بالعربية"><br>
        <input type="text" name="major_english" value="<?php echo htmlspecialchars($cv['major_english']); ?>" placeholder="التخصص بالإنجليزية"><br>
        <input type="text" name="specialization_arabic" value="<?php echo htmlspecialchars($cv['specialization_arabic']); ?>" placeholder="التخصص الدقيق بالعربية"><br>
        <input type="text" name="specialization_english" value="<?php echo htmlspecialchars($cv['specialization_english']); ?>" placeholder="التخصص الدقيق بالإنجليزية"><br>
        <label>اللقب العلمي:</label><br>
        <select name="academic_title">
            <option value="None" <?php echo $cv['academic_title'] == 'None' ? 'selected' : ''; ?>>لايوجد</option>
            <option value="Assistant Lecturer" <?php echo $cv['academic_title'] == 'Assistant Lecturer' ? 'selected' : ''; ?>>مدرس مساعد</option>
            <option value="Lecturer" <?php echo $cv['academic_title'] == 'Lecturer' ? 'selected' : ''; ?>>مدرس</option>
            <option value="Assistant Professor" <?php echo $cv['academic_title'] == 'Assistant Professor' ? 'selected' : ''; ?>>أستاذ مساعد</option>
            <option value="Professor" <?php echo $cv['academic_title'] == 'Professor' ? 'selected' : ''; ?>>أستاذ</option>
        </select><br>


        <!-- باقي الحقول مثل الروابط العلمية، الكتب، المؤتمرات -->
        <label>رابط Scopus:</label><br>
        <input type="url" name="scopus_link" value="<?php echo htmlspecialchars($cv['scopus_link']); ?>"><br>
        <label>رابط ORCID:</label><br>
        <input type="url" name="orcid_link" value="<?php echo htmlspecialchars($cv['orcid_link']); ?>"><br>
        <label>رابط WOS:</label><br>
        <input type="url" name="wos_link" value="<?php echo htmlspecialchars($cv['wos_link']); ?>"><br>
        <label>رابط Google Scholar:</label><br>
        <input type="url" name="google_scholar_link" value="<?php echo htmlspecialchars($cv['google_scholar_link']); ?>"><br>
        <label>رابط ResearchGate:</label><br>
        <input type="url" name="researchgate_link" value="<?php echo htmlspecialchars($cv['researchgate_link']); ?>"><br>

        <!-- الحقول الخاصة بالنتاج العلمي -->
        <label>عدد الكتب:</label><br>
        <input type="number" name="books_count" value="<?php echo $cv['books_count']; ?>"><br>
        <label>عدد فصول الكتاب:</label><br>
        <input type="number" name="book_chapters_count" value="<?php echo $cv['book_chapters_count']; ?>"><br>
        <label>عدد البحوث والمقالات:</label><br>
        <input type="number" name="research_papers_count" value="<?php echo $cv['research_papers_count']; ?>"><br>

        <!-- إضافة الحقول الخاصة بالتدريس -->
        <label>عدد المؤتمرات:</label><br>
        <input type="number" name="conferences_count" value="<?php echo $cv['conferences_count']; ?>"><br>
        <label>عدد ورش العمل:</label><br>
        <input type="number" name="workshops_count" value="<?php echo $cv['workshops_count']; ?>"><br>
<label>مؤشر H في Scopus:</label><br>
<input type="number" name="h_index_scopus" value="<?php echo $cv['h_index_scopus']; ?>"><br>

<label>مؤشر H في Clarivate:</label><br>
<input type="number" name="h_index_clarivate" value="<?php echo $cv['h_index_clarivate']; ?>"><br>

<label>معلومات إضافية (عربي):</label><br>
<textarea name="additional_info_arabic"><?php echo htmlspecialchars($cv['additional_info_arabic']); ?></textarea><br>

<label>معلومات إضافية (إنجليزي):</label><br>
<textarea name="additional_info_english"><?php echo htmlspecialchars($cv['additional_info_english']); ?></textarea><br>

<label>مكان العمل (عربي):</label><br>
<input type="text" name="workplace_arabic" value="<?php echo htmlspecialchars($cv['workplace_arabic']); ?>"><br>

<label>مكان العمل (إنجليزي):</label><br>
<input type="text" name="workplace_english" value="<?php echo htmlspecialchars($cv['workplace_english']); ?>"><br>

<label>العضويات العلمية (عربي):</label><br>
<textarea name="scientific_memberships_arabic"><?php echo htmlspecialchars($cv['scientific_memberships_arabic']); ?></textarea><br>

<label>العضويات العلمية (إنجليزي):</label><br>
<textarea name="scientific_memberships_english"><?php echo htmlspecialchars($cv['scientific_memberships_english']); ?></textarea><br>

<label>مجال البحث (عربي):</label><br>
<input type="text" name="research_area_arabic" value="<?php echo htmlspecialchars($cv['research_area_arabic']); ?>"><br>

<label>مجال البحث (إنجليزي):</label><br>
<input type="text" name="research_area_english" value="<?php echo htmlspecialchars($cv['research_area_english']); ?>"><br>

<label>التجربة التدريسية (عربي):</label><br>
<textarea name="teaching_experience_arabic"><?php echo htmlspecialchars($cv['teaching_experience_arabic']); ?></textarea><br>

<label>التجربة التدريسية (إنجليزي):</label><br>
<textarea name="teaching_experience_english"><?php echo htmlspecialchars($cv['teaching_experience_english']); ?></textarea><br>


        <h3>إضافة أو تحديث البحوث:</h3>
        <div id="research-fields">
            <?php foreach ($researches as $research): ?>
                <div class="research">
                    <label>عنوان البحث:</label><br>
                    <input type="text" name="research_title[]" value="<?php echo htmlspecialchars($research['title']); ?>" required><br>
                    <label>وصف البحث:</label><br>
                    <textarea name="research_description[]" required><?php echo htmlspecialchars($research['description']); ?></textarea><br>
                    <label>سنة البحث:</label><br>
                    <input type="number" name="research_year[]" value="<?php echo $research['year']; ?>" required><br>
                    <hr>
                </div>
            <?php endforeach; ?>
        </div>
        <button type="button" onclick="addResearch()">إضافة بحث جديد</button><br>

        <input type="submit" value="تحديث السيرة الذاتية">
    </form>

    <script>
        function addResearch() {
            var researchDiv = document.createElement('div');
            researchDiv.classList.add('research');
            
            researchDiv.innerHTML = `
                <label>عنوان البحث:</label><br>
                <input type="text" name="research_title[]" required><br>
                <label>وصف البحث:</label><br>
                <textarea name="research_description[]" required></textarea><br>
                <label>سنة البحث:</label><br>
                <input type="number" name="research_year[]" required><br>
                <hr>
            `;
            
            document.getElementById('research-fields').appendChild(researchDiv);
        }
    </script>

</body>
</html>
