<?php
include 'config.php';

if (isset($_GET['id'])) {
    $user_id = $_GET['id'];

    // استعلام لجلب بيانات المستخدم
    $sql = "SELECT * FROM users WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['id' => $user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // استعلام لتحديث بيانات المستخدم
    $sql = "UPDATE users SET email = :email, password = :password WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['email' => $email, 'password' => password_hash($password, PASSWORD_DEFAULT), 'id' => $user_id]);

    echo "تم تحديث البيانات بنجاح";
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>تعديل المستخدم</title>
</head>
<body>
    <h1>تعديل بيانات المستخدم</h1>
    <form method="post">
        <label>البريد الإلكتروني:</label><br>
        <input type="email" name="email" value="<?php echo htmlspecialchars($user['email']); ?>" required><br>
        <label>كلمة المرور:</label><br>
        <input type="password" name="password" required><br>
        <input type="submit" value="تحديث">
    </form>
</body>
</html>
