<?php
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // التحقق من بيانات المستخدم
    $sql = "SELECT * FROM users WHERE email = :email";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['email' => $email]);

    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {
        session_start();
        $_SESSION['user_id'] = $user['id']; // تعيين المعرف في الجلسة

        // إعادة التوجيه إلى صفحة السيرة الذاتية
        header("Location: edit_cv.php");
        exit();
    } else {
        echo "البريد الإلكتروني أو كلمة المرور غير صحيحة.";
    }
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>تسجيل الدخول</title>
</head>
<body>
    <h1>تسجيل الدخول</h1>
    <form method="POST">
        <label>البريد الإلكتروني:</label><br>
        <input type="email" name="email" required><br>
        <label>كلمة المرور:</label><br>
        <input type="password" name="password" required><br>
        <input type="submit" value="دخول">
    </form>
</body>
</html>
