<?php
include 'config.php';
session_start();

// التحقق من وجود مشرف
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

// استعلام لعرض جميع المشرفين
$sql = "SELECT * FROM users WHERE role = 'admin'";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$admins = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>إدارة المشرفين</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            direction: rtl;
            text-align: right;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: center;
        }
        a {
            text-decoration: none;
            color: blue;
        }
        a:hover {
            text-decoration: underline;
        }
        .admin-links {
            margin: 20px 0;
        }
        .logout {
            margin-top: 20px;
            display: inline-block;
            padding: 10px;
            background-color: #f44336;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
        .logout:hover {
            background-color: #d32f2f;
        }
    </style>
</head>
<body>
    <h1>إدارة المشرفين</h1>

    <!-- رابط العودة إلى لوحة تحكم المشرف -->
    <div class="admin-links">
        <a href="dashboard_admin.php">الرجوع إلى لوحة تحكم المشرف</a>
    </div>

    <!-- جدول عرض المشرفين -->
    <h2>قائمة المشرفين</h2>
    <table>
        <thead>
            <tr>
                <th>البريد الإلكتروني</th>
                <th>تاريخ التسجيل</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($admins as $admin): ?>
                <tr>
                    <td><?php echo htmlspecialchars($admin['email']); ?></td>
                    <td><?php echo $admin['registration_date']; ?></td>
                    <td>
                        <a href="edit_admin.php?id=<?php echo $admin['id']; ?>">تعديل</a> |
                        <a href="delete_admin.php?id=<?php echo $admin['id']; ?>">حذف</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- زر إضافة مشرف جديد -->
    <h2>إضافة مشرف جديد</h2>
    <form method="post" action="create_admin.php">
        <label>البريد الإلكتروني:</label><br>
        <input type="email" name="email" required><br>
        <label>كلمة المرور:</label><br>
        <input type="password" name="password" required><br>
        <input type="submit" value="إضافة مشرف">
    </form>

    <!-- زر الخروج -->
    <a href="logout.php" class="logout">تسجيل الخروج</a>
</body>
</html>
