<?php
include 'config.php';

// التحقق من وجود cv_code في الرابط
if (isset($_GET['cv_code'])) {
    $cv_code = $_GET['cv_code']; // الحصول على cv_code من الرابط

    // استعلام للبحث عن السيرة الذاتية باستخدام cv_code
    $sql = "SELECT * FROM cv WHERE cv_code = :cv_code";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['cv_code' => $cv_code]);

    // التحقق من وجود السيرة الذاتية في قاعدة البيانات
    if ($stmt->rowCount() > 0) {
        $cv = $stmt->fetch(PDO::FETCH_ASSOC); // جلب السيرة الذاتية

        // عرض السيرة الذاتية
        echo "<h1>السيرة الذاتية لـ " . htmlspecialchars($cv['arabic_name']) . "</h1>";
        echo "<p><strong>الاسم بالإنجليزية:</strong> " . htmlspecialchars($cv['english_name']) . "</p>";
        echo "<p><strong>البريد الإلكتروني الشخصي:</strong> " . htmlspecialchars($cv['personal_email']) . "</p>";
        echo "<p><strong>البريد الإلكتروني الجامعي:</strong> " . htmlspecialchars($cv['university_email']) . "</p>";
        echo "<p><strong>تاريخ الميلاد:</strong> " . htmlspecialchars($cv['birth_date']) . "</p>";
        echo "<p><strong>الجنس:</strong> " . htmlspecialchars($cv['gender']) . "</p>";
        echo "<p><strong>الموقع الإلكتروني:</strong> " . htmlspecialchars($cv['website']) . "</p>";
        echo "<p><strong>رقم الموبايل:</strong> " . htmlspecialchars($cv['phone_number']) . "</p>";

        // عرض الصورة الشخصية إذا كانت موجودة
        if (!empty($cv['profile_picture'])) {
            echo "<p><strong>الصورة الشخصية:</strong><br><img src='" . htmlspecialchars($cv['profile_picture']) . "' alt='الصورة الشخصية' style='max-width:200px;'></p>";
        }

        // تفاصيل التعليم والتخصص
        echo "<h3>التخصص والشهادات</h3>";
        echo "<p><strong>الشهادة:</strong> " . htmlspecialchars($cv['degree']) . "</p>";
        echo "<p><strong>التخصص العام بالعربية:</strong> " . htmlspecialchars($cv['major_arabic']) . "</p>";
        echo "<p><strong>التخصص العام بالإنجليزية:</strong> " . htmlspecialchars($cv['major_english']) . "</p>";
        echo "<p><strong>التخصص الدقيق بالعربية:</strong> " . htmlspecialchars($cv['specialization_arabic']) . "</p>";
        echo "<p><strong>التخصص الدقيق بالإنجليزية:</strong> " . htmlspecialchars($cv['specialization_english']) . "</p>";
        echo "<p><strong>اللقب العلمي:</strong> " . htmlspecialchars($cv['academic_title']) . "</p>";

        // تفاصيل الروابط العلمية
        echo "<h3>الروابط العلمية</h3>";
        echo "<p><strong>رابط Scopus:</strong> " . htmlspecialchars($cv['scopus_link']) . "</p>";
        echo "<p><strong>رابط ORCID:</strong> " . htmlspecialchars($cv['orcid_link']) . "</p>";
        echo "<p><strong>رابط WOS:</strong> " . htmlspecialchars($cv['wos_link']) . "</p>";
        echo "<p><strong>رابط Google Scholar:</strong> " . htmlspecialchars($cv['google_scholar_link']) . "</p>";
        echo "<p><strong>رابط ResearchGate:</strong> " . htmlspecialchars($cv['researchgate_link']) . "</p>";

        // تفاصيل الإنجازات العلمية
        echo "<h3>الإنجازات العلمية</h3>";
        echo "<p><strong>عدد الكتب:</strong> " . htmlspecialchars($cv['books_count']) . "</p>";
        echo "<p><strong>عدد فصول الكتاب:</strong> " . htmlspecialchars($cv['book_chapters_count']) . "</p>";
        echo "<p><strong>عدد البحوث والمقالات:</strong> " . htmlspecialchars($cv['research_papers_count']) . "</p>";
        echo "<p><strong>عدد المؤتمرات:</strong> " . htmlspecialchars($cv['conferences_count']) . "</p>";
        echo "<p><strong>عدد ورش العمل:</strong> " . htmlspecialchars($cv['workshops_count']) . "</p>";
        echo "<p><strong>عدد h-index في سكوبس:</strong> " . htmlspecialchars($cv['h_index_scopus']) . "</p>";
        echo "<p><strong>عدد h-index في كلارفيت:</strong> " . htmlspecialchars($cv['h_index_clarivate']) . "</p>";

        // معلومات إضافية
        echo "<h3>المعلومات الإضافية</h3>";
        echo "<p><strong>المعلومات الإضافية بالعربية:</strong> " . htmlspecialchars($cv['additional_info_arabic']) . "</p>";
        echo "<p><strong>المعلومات الإضافية بالإنجليزية:</strong> " . htmlspecialchars($cv['additional_info_english']) . "</p>";

        // مكان العمل والعضويات العلمية
        echo "<h3>مكان العمل والعضويات العلمية</h3>";
        echo "<p><strong>مكان العمل بالعربية:</strong> " . htmlspecialchars($cv['workplace_arabic']) . "</p>";
        echo "<p><strong>مكان العمل بالإنجليزية:</strong> " . htmlspecialchars($cv['workplace_english']) . "</p>";
        echo "<p><strong>العضويات العلمية بالعربية:</strong> " . htmlspecialchars($cv['scientific_memberships_arabic']) . "</p>";
        echo "<p><strong>العضويات العلمية بالإنجليزية:</strong> " . htmlspecialchars($cv['scientific_memberships_english']) . "</p>";
        
        // مجال البحث والخبرة
        echo "<h3>المجال البحثي والخبرة</h3>";
        echo "<p><strong>المجال البحثي بالعربية:</strong> " . htmlspecialchars($cv['research_area_arabic']) . "</p>";
        echo "<p><strong>المجال البحثي بالإنجليزية:</strong> " . htmlspecialchars($cv['research_area_english']) . "</p>";
        echo "<p><strong>التدريس والخبرة بالعربية:</strong> " . htmlspecialchars($cv['teaching_experience_arabic']) . "</p>";
        echo "<p><strong>التدريس والخبرة بالإنجليزية:</strong> " . htmlspecialchars($cv['teaching_experience_english']) . "</p>";

        // عرض البحوث للمستخدم
        echo "<h3>البحوث العلمية</h3>";
        $sql = "SELECT * FROM researches WHERE user_id = :user_id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(['user_id' => $cv['user_id']]);
        $researches = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($researches) {
            echo "<ul>";
            foreach ($researches as $research) {
                echo "<li><strong>عنوان البحث:</strong> " . htmlspecialchars($research['title']) . "<br>";
                echo "<strong>وصف البحث:</strong> " . htmlspecialchars($research['description']) . "<br>";
                echo "<strong>سنة البحث:</strong> " . htmlspecialchars($research['year']) . "</li><br>";
            }
            echo "</ul>";
        } else {
            echo "<p>لا توجد بحوث علمية لهذا المستخدم.</p>";
        }

    } else {
        echo "السيرة الذاتية غير موجودة.";
    }
} else {
    echo "رمز السيرة الذاتية غير صحيح.";
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>عرض السيرة الذاتية</title>
</head>
<body>
    <h2>التفاصيل الشخصية</h2>
    <!-- عرض البيانات المعروضة هنا -->
</body>
</html>
