<?php
include 'config.php';
session_start();

// التحقق من وجود مشرف
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

// استعلام لعرض الأكواد الترويجية
$sql = "SELECT * FROM promo_codes";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$promo_codes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>متابعة الأكواد الترويجية</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            direction: rtl;
            text-align: right;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: center;
        }
        .logout {
            margin-top: 20px;
            display: inline-block;
            padding: 10px;
            background-color: #f44336;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
        .logout:hover {
            background-color: #d32f2f;
        }
    </style>
</head>
<body>
    <h1>متابعة الأكواد الترويجية</h1>
    
    <!-- جدول عرض الأكواد الترويجية -->
    <table>
        <thead>
            <tr>
                <th>الكود الترويجي</th>
                <th>الحالة</th>
                <th>تاريخ الانتهاء</th>
                <th>المستخدم الذي استعمل الكود</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($promo_codes as $promo): ?>
                <tr>
                    <td><?php echo htmlspecialchars($promo['code']); ?></td>
                    <td>
                        <?php echo $promo['is_used'] ? 'مستعمل' : 'جديد'; ?>
                    </td>
                    <td><?php echo $promo['expiration_date']; ?></td>
                    <td>
                        <?php
                        // إذا تم استخدام الكود، عرض المستخدم الذي استعمله
                        if ($promo['used_by']) {
                            $sql = "SELECT email FROM users WHERE id = :user_id";
                            $stmt = $pdo->prepare($sql);
                            $stmt->execute(['user_id' => $promo['used_by']]);
                            $user = $stmt->fetch(PDO::FETCH_ASSOC);
                            echo $user['email'];
                        } else {
                            echo "لم يتم استخدامه بعد";
                        }
                        ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- زر الخروج -->
    <a href="logout.php" class="logout">تسجيل الخروج</a>
</body>
</html>
