<?php
include 'config.php';

// استعلام لعرض الأكواد الترويجية
$sql = "SELECT * FROM promo_codes";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$promo_codes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>متابعة الأكواد الترويجية</title>
</head>
<body>
    <h1>متابعة الأكواد الترويجية</h1>
    <table border="1">
        <thead>
            <tr>
                <th>الكود</th>
                <th>الحالة</th>
                <th>مستخدم بواسطة</th>
                <th>تاريخ الاستخدام</th>
                <th>تاريخ الانتهاء</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($promo_codes as $promo): ?>
                <tr>
                    <td><?php echo htmlspecialchars($promo['code']); ?></td>
                    <td><?php echo $promo['is_used'] ? 'مستخدم' : 'جديد'; ?></td>
                    <td><?php echo $promo['used_by'] ? $promo['used_by'] : 'لم يتم استخدامه'; ?></td>
                    <td><?php echo $promo['use_date'] ? $promo['use_date'] : 'لم يتم استخدامه بعد'; ?></td>
                    <td><?php echo $promo['expiration_date']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
