<?php
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    // التحقق من التسجيل السابق للبريد الإلكتروني
    $sql = "SELECT * FROM users WHERE email = :email";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['email' => $email]);

    if ($stmt->rowCount() > 0) {
        echo "البريد الإلكتروني مسجل بالفعل!";
    } else {
        // إضافة المستخدم إلى قاعدة البيانات
        $sql = "INSERT INTO users (email, password) VALUES (:email, :password)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(['email' => $email, 'password' => password_hash($password, PASSWORD_DEFAULT)]);
        echo "تم التسجيل بنجاح!";
    }
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>التسجيل</title>
</head>
<body>
    <h1>التسجيل</h1>
    <form method="post">
        <label>البريد الإلكتروني:</label><br>
        <input type="email" name="email" required><br>
        <label>كلمة المرور:</label><br>
        <input type="password" name="password" required><br>
        <input type="submit" value="تسجيل">
    </form>
</body>
</html>
