<?php
include 'config.php';
session_start();

// التحقق من صلاحيات المشرف
if (!isset($_SESSION['admin_id'])) {
    die("الرجاء تسجيل الدخول كمسؤول.");
}

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['cv_code'])) {
        $cv_code = $_GET['cv_code'];  // الحصول على cv_code من الرابط

        // جلب السيرة الذاتية باستخدام cv_code
        $sql = "SELECT * FROM cv WHERE cv_code = :cv_code";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(['cv_code' => $cv_code]);

        // التحقق إذا كانت السيرة الذاتية موجودة
        if ($stmt->rowCount() > 0) {
            $cv = $stmt->fetch(PDO::FETCH_ASSOC);

            // تبديل حالة السيرة الذاتية
            $new_status = $cv['is_active'] == 1 ? 0 : 1; // إذا كانت نشطة، جعلها غير نشطة والعكس

            // تحديث حالة السيرة الذاتية
            $sql = "UPDATE cv SET is_active = :new_status WHERE cv_code = :cv_code";
            $stmt = $pdo->prepare($sql);
            $stmt->execute(['new_status' => $new_status, 'cv_code' => $cv_code]);

            if ($new_status == 1) {
                echo "تم تفعيل السيرة الذاتية.";
            } else {
                echo "تم تعطيل السيرة الذاتية.";
            }
        } else {
            echo "السيرة الذاتية غير موجودة.";
        }
    } else {
        echo "رمز السيرة الذاتية غير موجود.";
    }
} else {
    echo "طريقة الطلب غير صحيحة.";
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>تبديل حالة السيرة الذاتية</title>
</head>
<body>
    <h1>تبديل حالة السيرة الذاتية</h1>
    <form method="get">
        <label>رمز السيرة الذاتية:</label><br>
        <input type="text" name="cv_code" required><br>
        <input type="submit" value="تبديل الحالة">
    </form>
</body>
</html>
