<?php
include 'config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    die("الرجاء تسجيل الدخول أولاً.");
}

// الحصول على بيانات السيرة الذاتية للمستخدم
$user_id = $_SESSION['user_id'];
$sql = "SELECT * FROM cv WHERE user_id = :user_id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['user_id' => $user_id]);
$cv = $stmt->fetch(PDO::FETCH_ASSOC);

// جلب البحوث الحالية للمستخدم
$sql = "SELECT * FROM researches WHERE user_id = :user_id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['user_id' => $user_id]);
$researches = $stmt->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // استلام البيانات من النموذج
    $arabic_name = $_POST['arabic_name'];
    $english_name = $_POST['english_name'];
    $personal_email = $_POST['personal_email'];
    
    // تحديث السيرة الذاتية
    $sql = "UPDATE cv SET 
            arabic_name = :arabic_name, 
            english_name = :english_name, 
            personal_email = :personal_email 
            WHERE user_id = :user_id";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'arabic_name' => $arabic_name,
        'english_name' => $english_name,
        'personal_email' => $personal_email,
        'user_id' => $user_id
    ]);

    // تحديث البحوث
    if (!empty($_POST['research_title'])) {
        // حذف البحوث القديمة
        $sql = "DELETE FROM researches WHERE user_id = :user_id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(['user_id' => $user_id]);

        // إدخال البحوث الجديدة
        foreach ($_POST['research_title'] as $index => $title) {
            // تحقق مما إذا كان البحث تم حذفه من الواجهة
            if (!empty($title)) {
                $description = $_POST['research_description'][$index];
                $year = $_POST['research_year'][$index];

                $sql = "INSERT INTO researches (user_id, title, description, year) VALUES (:user_id, :title, :description, :year)";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([
                    'user_id' => $user_id,
                    'title' => $title,
                    'description' => $description,
                    'year' => $year
                ]);
            }
        }
    }

    // استرجاع البحوث بعد التحديث لعرضها
    $sql = "SELECT * FROM researches WHERE user_id = :user_id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['user_id' => $user_id]);
    $researches = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "تم تحديث البحوث بنجاح!";
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>تحديث البحوث</title>
    <style>
        .remove-research {
            color: red;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <h1>تحديث البحوث</h1>
    <form method="post">
        <label>الاسم بالعربية:</label><br>
        <input type="text" name="arabic_name" value="<?php echo htmlspecialchars($cv['arabic_name']); ?>" readonly required><br>
        <label>الاسم بالإنجليزية:</label><br>
        <input type="text" name="english_name" value="<?php echo htmlspecialchars($cv['english_name']); ?>" readonly required><br>

        <h3>إضافة أو تحديث البحوث:</h3>
        <div id="research-fields">
            <?php foreach ($researches as $research): ?>
                <div class="research">
                    <label>عنوان البحث:</label><br>
                    <input type="text" name="research_title[]" value="<?php echo htmlspecialchars($research['title']); ?>" required><br>
                    <label>وصف البحث:</label><br>
                    <textarea name="research_description[]" required><?php echo htmlspecialchars($research['description']); ?></textarea><br>
                    <label>سنة البحث:</label><br>
                    <input type="number" name="research_year[]" value="<?php echo $research['year']; ?>" required><br>
                    <span class="remove-research" onclick="removeResearch(this)">حذف البحث</span>
                    <hr>
                </div>
            <?php endforeach; ?>
        </div>
        <button type="button" onclick="addResearch()">إضافة بحث جديد</button><br>

        <input type="submit" value="تحديث السيرة الذاتية">
    </form>

    <script>
        function addResearch() {
            var researchDiv = document.createElement('div');
            researchDiv.classList.add('research');
            
            researchDiv.innerHTML = `
                <label>عنوان البحث:</label><br>
                <input type="text" name="research_title[]" required><br>
                <label>وصف البحث:</label><br>
                <textarea name="research_description[]" required></textarea><br>
                <label>سنة البحث:</label><br>
                <input type="number" name="research_year[]" required><br>
                <span class="remove-research" onclick="removeResearch(this)">حذف البحث</span>
                <hr>
            `;
            
            document.getElementById('research-fields').appendChild(researchDiv);
        }

        function removeResearch(element) {
            // إزالة البحث من الواجهة
            var researchDiv = element.parentElement;
            researchDiv.remove();
        }
    </script>
</body>
</html>
