<?php
include 'config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    die("الرجاء تسجيل الدخول أولاً.");
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $promo_code = $_POST['promo_code'];
    $user_id = $_SESSION['user_id'];

    // التحقق من الكود الترويجي
    $sql = "SELECT * FROM promo_codes WHERE code = :code AND is_used = 0 AND expiration_date > NOW()";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['code' => $promo_code]);

    $promo = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($promo) {
        // تحديث الكود ليتم استخدامه
        $sql = "UPDATE promo_codes SET is_used = 1, used_by = :user_id, use_date = NOW() WHERE code = :code";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(['user_id' => $user_id, 'code' => $promo_code]);

        echo "تمت ترقية حسابك بنجاح!";
    } else {
        echo "الكود غير صالح أو تم استخدامه مسبقًا.";
    }
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>ترقية الحساب</title>
</head>
<body>
    <h1>ترقية الحساب باستخدام الكود الترويجي</h1>
    <form method="post">
        <label>الكود الترويجي:</label><br>
        <input type="text" name="promo_code" required><br>
        <input type="submit" value="ترقية">
    </form>
</body>
</html>
