<?php
include 'config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    die("الرجاء تسجيل الدخول أولاً.");
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['profile_picture'])) {
    $file = $_FILES['profile_picture'];

    // التحقق من نوع وحجم الصورة
    if ($file['error'] === 0 && in_array($file['type'], ['image/jpeg', 'image/png'])) {
        $image_size = getimagesize($file['tmp_name']);
        $max_size = 100 * 1024; // 100KB

        if ($file['size'] <= $max_size) {
            // حفظ الصورة في المجلد
            $file_name = uniqid() . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
            if (move_uploaded_file($file['tmp_name'], 'uploads/' . $file_name)) {
                // تحديث قاعدة البيانات
                $sql = "UPDATE cv SET profile_picture = :file_name WHERE user_id = :user_id";
                $stmt = $pdo->prepare($sql);

                // تحقق من تنفيذ الاستعلام بنجاح
                try {
                    $stmt->execute(['file_name' => $file_name, 'user_id' => $_SESSION['user_id']]);
                    echo "تم رفع الصورة بنجاح!";
                } catch (PDOException $e) {
                    echo "فشل في تحديث قاعدة البيانات: " . $e->getMessage();
                }
            } else {
                echo "فشل في تحميل الصورة إلى المجلد.";
            }
        } else {
            echo "الصورة كبيرة جدًا. الحد الأقصى هو 100KB.";
        }
    } else {
        echo "حدث خطأ أثناء رفع الصورة. تأكد من أنك قد قمت باختيار صورة بتنسيق JPEG أو PNG.";
    }
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>رفع الصورة الشخصية</title>
</head>
<body>
    <h1>رفع الصورة الشخصية</h1>
    <form method="post" enctype="multipart/form-data">
        <label>اختر صورة:</label><br>
        <input type="file" name="profile_picture" required><br>
        <input type="submit" value="رفع الصورة">
    </form>
</body>
</html>
