<?php
include 'config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    die("الرجاء تسجيل الدخول أولاً.");
}

// الحصول على بيانات السيرة الذاتية للمستخدم
$user_id = $_SESSION['user_id'];
$sql = "SELECT * FROM cv WHERE user_id = :user_id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['user_id' => $user_id]);
$cv = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$cv) {
    echo "لا توجد سيرة ذاتية لهذا المستخدم.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>عرض السيرة الذاتية</title>
</head>
<body>
    <h1>السيرة الذاتية</h1>
    <p>الاسم بالعربية: <?php echo htmlspecialchars($cv['arabic_name']); ?></p>
    <p>الاسم بالإنجليزية: <?php echo htmlspecialchars($cv['english_name']); ?></p>
    <p>البريد الإلكتروني الشخصي: <?php echo htmlspecialchars($cv['personal_email']); ?></p>
    <p>البريد الإلكتروني الجامعي: <?php echo htmlspecialchars($cv['university_email']); ?></p>
    <p>تاريخ الميلاد: <?php echo $cv['birth_date']; ?></p>
    <p>الجنس: <?php echo $cv['gender']; ?></p>
    <p>الموقع الإلكتروني: <?php echo htmlspecialchars($cv['website']); ?></p>
    <p>رقم الموبايل: <?php echo htmlspecialchars($cv['phone_number']); ?></p>
    <p>الشهادة: <?php echo $cv['degree']; ?></p>
    <p>التخصص: <?php echo htmlspecialchars($cv['major_arabic']); ?> - <?php echo htmlspecialchars($cv['major_english']); ?></p>
    <p>التخصص الدقيق: <?php echo htmlspecialchars($cv['specialization_arabic']); ?> - <?php echo htmlspecialchars($cv['specialization_english']); ?></p>
    <p>اللقب العلمي: <?php echo $cv['academic_title']; ?></p>
    <p>Scopus: <a href="<?php echo htmlspecialchars($cv['scopus_link']); ?>"><?php echo $cv['scopus_link'] ? 'رابط' : 'غير متوفر'; ?></a></p>
    <p>ORCID: <a href="<?php echo htmlspecialchars($cv['orcid_link']); ?>"><?php echo $cv['orcid_link'] ? 'رابط' : 'غير متوفر'; ?></a></p>
    <p>WOS: <a href="<?php echo htmlspecialchars($cv['wos_link']); ?>"><?php echo $cv['wos_link'] ? 'رابط' : 'غير متوفر'; ?></a></p>
    <p>Google Scholar: <a href="<?php echo htmlspecialchars($cv['google_scholar_link']); ?>"><?php echo $cv['google_scholar_link'] ? 'رابط' : 'غير متوفر'; ?></a></p>
    <p>ResearchGate: <a href="<?php echo htmlspecialchars($cv['researchgate_link']); ?>"><?php echo $cv['researchgate_link'] ? 'رابط' : 'غير متوفر'; ?></a></p>
    
    <h3>النتاج العلمي</h3>
    <p>عدد الكتب: <?php echo $cv['books_count']; ?></p>
    <p>عدد فصول الكتاب: <?php echo $cv['book_chapters_count']; ?></p>
    <p>عدد البحوث والمقالات: <?php echo $cv['research_papers_count']; ?></p>
    <p>عدد المؤتمرات: <?php echo $cv['conferences_count']; ?></p>
    <p>عدد ورش العمل: <?php echo $cv['workshops_count']; ?></p>
    <p>عدد H-index في Scopus: <?php echo $cv['h_index_scopus']; ?></p>
    <p>عدد H-index في Clarivate: <?php echo $cv['h_index_clarivate']; ?></p>
    
    <h3>معلومات إضافية</h3>
    <p>المعلومات الإضافية بالعربية: <?php echo htmlspecialchars($cv['additional_info_arabic']); ?></p>
    <p>المعلومات الإضافية بالإنجليزية: <?php echo htmlspecialchars($cv['additional_info_english']); ?></p>

    <h3>مكان العمل</h3>
    <p>بالعربية: <?php echo htmlspecialchars($cv['workplace_arabic']); ?></p>
    <p>بالإنجليزية: <?php echo htmlspecialchars($cv['workplace_english']); ?></p>

    <h3>العضويات العلمية</h3>
    <p>بالعربية: <?php echo htmlspecialchars($cv['scientific_memberships_arabic']); ?></p>
    <p>بالإنجليزية: <?php echo htmlspecialchars($cv['scientific_memberships_english']); ?></p>

    <h3>المساحة البحثية</h3>
    <p>بالعربية: <?php echo htmlspecialchars($cv['research_area_arabic']); ?></p>
    <p>بالإنجليزية: <?php echo htmlspecialchars($cv['research_area_english']); ?></p>

    <h3>الخبرة والتدريس</h3>
    <p>بالعربية: <?php echo htmlspecialchars($cv['teaching_experience_arabic']); ?></p>
    <p>بالإنجليزية: <?php echo htmlspecialchars($cv['teaching_experience_english']); ?></p>
</body>
</html>
<?php
include 'config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    die("الرجاء تسجيل الدخول أولاً.");
}

// الحصول على بيانات السيرة الذاتية للمستخدم
$user_id = $_SESSION['user_id'];
$sql = "SELECT * FROM cv WHERE user_id = :user_id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['user_id' => $user_id]);
$cv = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$cv) {
    echo "لا توجد سيرة ذاتية لهذا المستخدم.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>عرض السيرة الذاتية</title>
</head>
<body>
    <h1>السيرة الذاتية</h1>
    <p>الاسم بالعربية: <?php echo htmlspecialchars($cv['arabic_name']); ?></p>
    <p>الاسم بالإنجليزية: <?php echo htmlspecialchars($cv['english_name']); ?></p>
    <p>البريد الإلكتروني الشخصي: <?php echo htmlspecialchars($cv['personal_email']); ?></p>
    <p>البريد الإلكتروني الجامعي: <?php echo htmlspecialchars($cv['university_email']); ?></p>
    <p>تاريخ الميلاد: <?php echo $cv['birth_date']; ?></p>
    <p>الجنس: <?php echo $cv['gender']; ?></p>
    <p>الموقع الإلكتروني: <?php echo htmlspecialchars($cv['website']); ?></p>
    <p>رقم الموبايل: <?php echo htmlspecialchars($cv['phone_number']); ?></p>
    <p>الشهادة: <?php echo $cv['degree']; ?></p>
    <p>التخصص: <?php echo htmlspecialchars($cv['major_arabic']); ?> - <?php echo htmlspecialchars($cv['major_english']); ?></p>
    <p>التخصص الدقيق: <?php echo htmlspecialchars($cv['specialization_arabic']); ?> - <?php echo htmlspecialchars($cv['specialization_english']); ?></p>
    <p>اللقب العلمي: <?php echo $cv['academic_title']; ?></p>
    <p>Scopus: <a href="<?php echo htmlspecialchars($cv['scopus_link']); ?>"><?php echo $cv['scopus_link'] ? 'رابط' : 'غير متوفر'; ?></a></p>
    <p>ORCID: <a href="<?php echo htmlspecialchars($cv['orcid_link']); ?>"><?php echo $cv['orcid_link'] ? 'رابط' : 'غير متوفر'; ?></a></p>
    <p>WOS: <a href="<?php echo htmlspecialchars($cv['wos_link']); ?>"><?php echo $cv['wos_link'] ? 'رابط' : 'غير متوفر'; ?></a></p>
    <p>Google Scholar: <a href="<?php echo htmlspecialchars($cv['google_scholar_link']); ?>"><?php echo $cv['google_scholar_link'] ? 'رابط' : 'غير متوفر'; ?></a></p>
    <p>ResearchGate: <a href="<?php echo htmlspecialchars($cv['researchgate_link']); ?>"><?php echo $cv['researchgate_link'] ? 'رابط' : 'غير متوفر'; ?></a></p>
    
    <h3>النتاج العلمي</h3>
    <p>عدد الكتب: <?php echo $cv['books_count']; ?></p>
    <p>عدد فصول الكتاب: <?php echo $cv['book_chapters_count']; ?></p>
    <p>عدد البحوث والمقالات: <?php echo $cv['research_papers_count']; ?></p>
    <p>عدد المؤتمرات: <?php echo $cv['conferences_count']; ?></p>
    <p>عدد ورش العمل: <?php echo $cv['workshops_count']; ?></p>
    <p>عدد H-index في Scopus: <?php echo $cv['h_index_scopus']; ?></p>
    <p>عدد H-index في Clarivate: <?php echo $cv['h_index_clarivate']; ?></p>
    
    <h3>معلومات إضافية</h3>
    <p>المعلومات الإضافية بالعربية: <?php echo htmlspecialchars($cv['additional_info_arabic']); ?></p>
    <p>المعلومات الإضافية بالإنجليزية: <?php echo htmlspecialchars($cv['additional_info_english']); ?></p>

    <h3>مكان العمل</h3>
    <p>بالعربية: <?php echo htmlspecialchars($cv['workplace_arabic']); ?></p>
    <p>بالإنجليزية: <?php echo htmlspecialchars($cv['workplace_english']); ?></p>

    <h3>العضويات العلمية</h3>
    <p>بالعربية: <?php echo htmlspecialchars($cv['scientific_memberships_arabic']); ?></p>
    <p>بالإنجليزية: <?php echo htmlspecialchars($cv['scientific_memberships_english']); ?></p>

    <h3>المساحة البحثية</h3>
    <p>بالعربية: <?php echo htmlspecialchars($cv['research_area_arabic']); ?></p>
    <p>بالإنجليزية: <?php echo htmlspecialchars($cv['research_area_english']); ?></p>

    <h3>الخبرة والتدريس</h3>
    <p>بالعربية: <?php echo htmlspecialchars($cv['teaching_experience_arabic']); ?></p>
    <p>بالإنجليزية: <?php echo htmlspecialchars($cv['teaching_experience_english']); ?></p>
</body>
</html>
