<?php
include 'config.php';
session_start();

// التحقق من وجود مشرف
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

// استعلام لعرض بعض التقارير مثل عدد المستخدمين
$sql = "SELECT COUNT(*) as user_count FROM users";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$user_count = $stmt->fetch(PDO::FETCH_ASSOC);

// استعلام لعرض عدد الأكواد الترويجية
$sql = "SELECT COUNT(*) as promo_count FROM promo_codes";
$stmt = $pdo->prepare($sql);
$stmt->execute();
$promo_count = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>عرض التقارير</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            direction: rtl;
            text-align: right;
        }
        .report-section {
            margin-bottom: 20px;
        }
        .logout {
            margin-top: 20px;
            display: inline-block;
            padding: 10px;
            background-color: #f44336;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
        .logout:hover {
            background-color: #d32f2f;
        }
    </style>
</head>
<body>
    <h1>عرض التقارير</h1>
    
    <!-- تقرير عدد المستخدمين -->
    <div class="report-section">
        <h2>عدد المستخدمين</h2>
        <p><?php echo $user_count['user_count']; ?> مستخدم</p>
    </div>

    <!-- تقرير عدد الأكواد الترويجية -->
    <div class="report-section">
        <h2>عدد الأكواد الترويجية</h2>
        <p><?php echo $promo_count['promo_count']; ?> كود ترويجي</p>
    </div>

    <!-- زر الخروج -->
    <a href="logout.php" class="logout">تسجيل الخروج</a>
</body>
</html>
