<?php
include 'config.php';
session_start();

// تمكين عرض الأخطاء
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// التحقق من وجود مشرف
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

// دالة لإنشاء الكود الترويجي
function generatePromoCode() {
    // توليد 5 مجموعات من 5 أحرف عشوائية
    $code = '';
    for ($i = 0; $i < 5; $i++) {
        $code .= strtoupper(bin2hex(openssl_random_pseudo_bytes(3))); // 3 بايت تولد 6 أحرف
        if ($i < 4) {
            $code .= '-';  // إضافة فاصل بين المجموعات
        }
    }
    return $code;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $number_of_codes = 100; // عدد الأكواد التي سيتم إنشاؤها
    $expiration_date = date('Y-m-d', strtotime('+1 year')); // تاريخ انتهاء الكود بعد سنة من اليوم

    // إدخال الأكواد إلى قاعدة البيانات
    for ($i = 0; $i < $number_of_codes; $i++) {
        $code = generatePromoCode();  // توليد الكود الترويجي

        // إضافة الكود إلى قاعدة البيانات
        try {
            $sql = "INSERT INTO promo_codes (code, expiration_date) VALUES (:code, :expiration_date)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute(['code' => $code, 'expiration_date' => $expiration_date]);
        } catch (PDOException $e) {
            echo "خطأ في إضافة الكود الترويجي: " . $e->getMessage();
            exit();
        }
    }

    echo "تم إنشاء 100 كود ترويجي بنجاح!";
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>إنشاء الأكواد الترويجية</title>
</head>
<body>
    <h1>إنشاء الأكواد الترويجية</h1>
    <form method="post">
        <input type="submit" value="إنشاء 100 كود">
    </form>
</body>
</html>
